PSCAD 4.2.0

Settings
 {
 Id = "976141504.1144683504"
 Author = "jayas.jayas"
 Desc = "Parallel Transmission Line (Mid-line Fault)"
 Arch = "windows"
 Options = 0
 Build = 19
 Warn = 7
 Check = 15
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 0.5
  Step = 5e-005
  Plot = 5e-005
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 511
  Debug = 0
  StartFile = ""
  OFile = "noname.out"
  SFile = "noname.snp"
  SnapTime = 0.3
  Mruns = 10
  Mrunfile = 0
  StartType = 0
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }


Global_Consts = 
  {
  f = 60.0 [Hz]
  }

 }

Definitions
 {
 Module("Controls")
  {
  Desc = ""
  FileDate = 1144683240
  Nodes = 
   {
   Output("BRKR",36,-36)
    {
    Type = Integer
    Dim  = [4]
    }
   Input("Flt_en",36,18)
    {
    Type = Integer
    }
   Output("FLT",36,0)
    {
    Type = Integer
    }
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Pen(Gray)
   Line(27,28,27,-43)
   Brush(,Silver)
   Rectangle(0,-13,3,0)
   Brush(,Gray)
   Rectangle(-3,-10,6,-7)
   Text(1,25,"Controls")
   Pen(Black)
   Line(27,18,36,18)
   Line(27,-36,36,-36)
   Line(27,0,36,0)
   Pen(ByNode)
   Brush(Hollow)
   Rectangle(-4,-18,7,3)
   }


  Page(B/A3,Landscape,16,[597,467],100)
   {
   0.datalabel([2016,378],3,0,-1)
    {
    Name = "B1T2"
    }
   0.datalabel([2016,432],3,0,-1)
    {
    Name = "B2T1"
    }
   0.datalabel([2016,486],3,0,-1)
    {
    Name = "B2T2"
    }
   -Wire-([720,720],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([756,720],0,0,-1)
    {
    Name = "Tfs"
    }
   0.datalabel([756,756],0,0,-1)
    {
    Name = "Tfd"
    }
   -ControlPanel-([180,450],0)
    {
    Name = "SOURCE 2"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,576,126
    Slider(40066096)
    Meter(40132080)
    Slider(40068960)
    Meter(40033952)
    Meter(39856512)
    Meter(39884024)
    Meter(39990256)
    Meter(40147096)
    }
   -Sticky-([684,162],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 684,162,846,270
    Alignment = 0
    Style = 1
    Arrow = 64
    Color = 0,15792890
    Text = "\
Adjust phase angle to obtain
the correct power flow. Adjust
voltage to obtain the matching
VAR flow at each end."
    }
   0.datalabel([2034,738],3,0,-1)
    {
    Name = "B3T1"
    }
   0.datalabel([2034,792],3,0,-1)
    {
    Name = "B3T2"
    }
   0.datalabel([2034,846],3,0,-1)
    {
    Name = "B4T1"
    }
   -Sticky-([1728,1008],0)
    {
    Name = ""
    Font = 1
    Bounds = 1728,1008,1836,1044
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Exports to Main Page"
    }
   0.datalabel([1800,1062],6,0,-1)
    {
    Name = "B1"
    }
   0.datalabel([1800,1080],6,0,-1)
    {
    Name = "B2"
    }
   0.datalabel([1800,1098],6,0,-1)
    {
    Name = "B3"
    }
   0.datalabel([1800,1116],6,0,-1)
    {
    Name = "B4"
    }
   -Sticky-([1728,180],0)
    {
    Name = ""
    Font = 1
    Bounds = 1728,180,1836,216
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "BREAKER CONTROLS"
    }
   -Sticky-([2016,180],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 2016,180,2196,252
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Adjust breaker clearing time (T1)
and reclose time (T2) if needed."
    }
   -Wire-([720,756],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -ControlPanel-([1728,306],0)
    {
    Name = "B1 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(39232312)
    Slider(39207584)
    Slider(39096480)
    }
   -ControlPanel-([1728,450],0)
    {
    Name = "B2 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(39213784)
    Slider(39093464)
    Slider(39204736)
    }
   0.datalabel([2034,900],3,0,-1)
    {
    Name = "B4T2"
    }
   0.tbreakn([2106,324],4,0,20)
    {
    NUMS = "1"
    INIT = "0"
    TO1 = "B1T1"
    TO2 = "B1T2"
    }
   0.tbreakn([2106,918],4,0,180)
    {
    NUMS = "1"
    INIT = "0"
    TO1 = "B4T1"
    TO2 = "B4T2"
    }
   0.var([1980,432],0,39093464,50)
    {
    Name = "B2T1"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = ""
    Collect = "1"
    }
   0.var([1980,378],0,39096480,40)
    {
    Name = "B1T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = ""
    Collect = "1"
    }
   -ControlPanel-([1728,684],0)
    {
    Name = "B3 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(39228016)
    Slider(39225160)
    Slider(39222304)
    }
   -ControlPanel-([1728,828],0)
    {
    Name = "B4 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(39235032)
    Slider(39219448)
    Slider(39216424)
    }
   0.datalabel([2016,324],3,0,-1)
    {
    Name = "B1T1"
    }
   -Wire-([2142,360],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.logic([2178,360],0,0,200)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([2142,432],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([2142,468],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.logic([2178,468],6,0,210)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([2160,828],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([2106,810],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([2106,810],4,0,-1)
    {
    Name = "flt_en"
    }
   -Wire-([2160,738],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.logic([2196,756],0,0,240)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([2160,738],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.logic([2196,864],6,0,250)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([2160,918],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([2160,918],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   0.tbreakn([2106,522],4,0,80)
    {
    NUMS = "1"
    INIT = "0"
    TO1 = "B2T1"
    TO2 = "B2T2"
    }
   0.datamerge([1818,1134],4,0,290)
    {
    N = "4"
    Type = "1"
    Disp = "1"
    }
   0.datalabel([1782,1206],4,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([1782,1206],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([882,738],4,0,-1)
    {
    Name = "Fault"
    }
   0.tbreakn([2106,738],4,0,130)
    {
    NUMS = "1"
    INIT = "0"
    TO1 = "B3T1"
    TO2 = "B3T2"
    }
   -Sticky-([180,666],0)
    {
    Name = ""
    Font = 1
    Bounds = 180,666,288,702
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "FAULT CONTROLS"
    }
   -Sticky-([180,252],0)
    {
    Name = ""
    Font = 1
    Bounds = 180,252,306,288
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "PREFAULT CONTROLS"
    }
   -Sticky-([1224,162],0)
    {
    Name = ""
    Font = 1
    Bounds = 1224,162,1332,198
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Playback Recorders"
    }
   0.datalabel([2088,414],4,0,-1)
    {
    Name = "flt_en"
    }
   -ControlPanel-([180,720],0)
    {
    Name = "Fault Location and Type"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Dial(40090416)
    Dial(40123200)
    }
   -ControlPanel-([414,720],0)
    {
    Name = "Start & Duration"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Slider(39198496)
    Slider(39195912)
    Slider(40161296)
    }
   0.export([1854,1152],4,0,320)
    {
    Name = "BRKR"
    }
   0.export([1872,1206],4,0,300)
    {
    Name = "FLT"
    }
   0.tfaultn([846,738],4,0,230)
    {
    TF = "Tfs"
    DF = "Tfd"
    }
   0.import([1962,1080],0,0,190)
    {
    Name = "Flt_en"
    }
   0.var([684,756],0,39195912,100)
    {
    Name = "Duration "
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.26"
    Units = ""
    Collect = "1"
    }
   0.var([684,720],0,39198496,90)
    {
    Name = "Fault Start "
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.2"
    Units = "s"
    Collect = "1"
    }
   0.pgb([1818,1206],1,39201520,310)
    {
    Name = "<Untitled>"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([2088,414],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.var([1980,486],0,39204736,60)
    {
    Name = "B2T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = ""
    Collect = "1"
    }
   0.var([1980,324],0,39207584,10)
    {
    Name = "B1T1"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "2.0"
    Units = ""
    Collect = "1"
    }
   0.logic([2250,324],0,0,270)
    {
    Type = "2"
    Inv = "0"
    }
   0.datalabel([2286,324],6,0,-1)
    {
    Name = "B1"
    }
   0.datalabel([2286,504],4,0,-1)
    {
    Name = "B2"
    }
   0.datalabel([2304,900],4,0,-1)
    {
    Name = "B4"
    }
   0.var_switch([2178,504],0,39213784,70)
    {
    Name = "42 B2"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var([1998,900],0,39216424,160)
    {
    Name = "B4T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.var([1998,846],0,39219448,150)
    {
    Name = "B4T1"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "0.45"
    Units = "s"
    Collect = "1"
    }
   0.var([1998,792],0,39222304,140)
    {
    Name = "B3T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.var([1998,738],0,39225160,110)
    {
    Name = "B3T1"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "0.35"
    Units = "s"
    Collect = "1"
    }
   0.var_switch([2196,720],0,39228016,120)
    {
    Name = "42 B3"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.datalabel([2304,720],2,0,-1)
    {
    Name = "B3"
    }
   0.logic([2250,504],6,0,220)
    {
    Type = "2"
    Inv = "0"
    }
   0.var_switch([2178,324],0,39232312,30)
    {
    Name = "42 B1"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([2196,900],0,39235032,170)
    {
    Name = "42 B4"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.logic([2268,720],0,0,280)
    {
    Type = "2"
    Inv = "0"
    }
   -Sticky-([450,864],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 450,864,576,1062
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> A-g
  2=> B-g
  3=> C-g
  4=> AB-g
  5=> AC-g
  6=> BC-g
  7=> ABC-g
  8=> AB 
  9=> AC 
10=> No fault 
11=> No fault (0)"
    }
   -Sticky-([684,810],0)
    {
    Name = ""
    Font = 1
    Bounds = 684,810,954,1116
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Example of a Test  Sequence 

Fault is located on Line 2 at B3 (Fault location 5)
Fault is 3 phase to Ground (Fault Type 7)

Fault occurs at 0.20 sec, Fault Duration 0.05 sec

Set Breakers:
B1T1 =  2.00:  Breaker B1 does not trip
B2T1 =  2.00:  Breaker B2 does not trip
B3T1 =  0.35:  Breaker B3 trips in 35 msec
B4T1 =  0.45:  Breaker B4 trips in 45 msec
B1T2 =  2.00:  Breaker B1 does not reclose
B2T2 =  2.00:  Breaker B2 does not reclose
B3T2 =  2.00:  Breaker B3 does not reclose
B4T2 =  2.00:  Breaker B4 does not reclose      

(Breaker  B1 and B2 do not automatically operate)
"
    }
   0.logic([2268,900],6,0,260)
    {
    Type = "2"
    Inv = "0"
    }
   -ControlPanel-([1224,216],0)
    {
    Name = "Recorders"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,144,126
    Slider(40192208)
    Slider(39791192)
    }
   -ControlPanel-([1152,360],0)
    {
    Name = "Recorder Control"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,288,126
    Switch(40199104)
    Switch(40201824)
    Switch(40204544)
    Switch(40207264)
    }
   -Sticky-([1152,522],0)
    {
    Name = ""
    Font = 1
    Bounds = 1152,522,1422,630
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
To turn the Recorders on, click on the switch.
On = Recorder will record data.
Off = Recorder will NOT record data.

You can turn off and  on each recorder individually."
    }
   -Sticky-([180,864],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 180,864,432,1188
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> FT1:
          Between Source and  breakers 
          (B1 and B3)
  2=> FT2: 
          Between B1 and Line1
  3=> FT3: 
          Midpoint on Line1
  4=> FT4: 
          Between Line1 and B2
  5=> FT5:
          Between breakers (B3 and B4)
          and Source
  6=> FT6:
          Between Line2 and B3
  7=> FT7:
          Midpoint on Line2
  8=> FT8:
          Between Line2 and B4"
    }
   -ControlPanel-([180,306],0)
    {
    Name = "SOURCE 1"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,576,126
    Slider(40060296)
    Meter(40126144)
    Slider(40063240)
    Meter(40001776)
    Meter(40008440)
    Meter(39886872)
    Meter(39984432)
    Meter(39987344)
    }
   -Divider-([162,648],0)
    {
    Size(1422,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([1584,990],0)
    {
    Size(756,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([1584,90],0)
    {
    Size(0,1278)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([990,108],0)
    {
    Size(0,540)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   }
  }
 Module("Plots_B1")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Line(-13,-1,-13,-21)
   Line(-18,-4,21,-4)
   Line(-13,-4,-4,-13)
   Line(-4,-13,1,-10)
   Line(6,-16,12,-13)
   Pen(Gray)
   Line(27,28,27,-43)
   Pen(Black)
   Line(1,-10,6,-16)
   Text(1,-28,"Plots")
   Text(3,24,"B1 B3")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Plot-([36,36],0)
    {
    Title = "Plots at B1"
    Draw = 1
    Area = [0,0,738,1152]
    Posn = [36,36]
    Icon = [-1,-1]
    Extents = 0,0,738,1152
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,738,277],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(39998864,"V1a",0,,,)
     Curve(39834568,"V1b",1,,,)
     Curve(39815120,"V1c",2,,,)
     }
    Graph([0,277],[0,0,738,277],"Current")
     {
     Options = 9
     Units = ""
     Curve(39889784,"I1a",0,,,)
     Curve(39905776,"I1b",1,,,)
     Curve(39892584,"I1c",2,,,)
     }
    Graph([0,554],[0,0,738,277],"Current")
     {
     Options = 9
     Units = ""
     Curve(39896336,"I10",0,,,)
     }
    PGraph([0,831],[0,0,738,258],"PolyGraph")
     {
     Options = 2
     Curve(40153104,"Br1a",0,,,1)
     Curve(39837344,"Br1b",1,,,1)
     Curve(39878456,"Br1c",2,,,1)
     }
    }
   -Plot-([810,36],0)
    {
    Title = "Plots at B3"
    Draw = 1
    Area = [0,0,738,1152]
    Posn = [810,36]
    Icon = [-1,-1]
    Extents = 0,0,738,1152
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,738,277],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(39940944,"V3a",0,,,)
     Curve(39943776,"V3b",1,,,)
     Curve(39946688,"V3c",2,,,)
     }
    Graph([0,277],[0,0,738,277],"Current")
     {
     Options = 9
     Units = ""
     Curve(39949600,"I3a",0,,,)
     Curve(39952512,"I3b",1,,,)
     Curve(39955424,"I3c",2,,,)
     }
    Graph([0,554],[0,0,738,277],"Current")
     {
     Options = 9
     Units = ""
     Curve(39958368,"I30",0,,,)
     }
    PGraph([0,831],[0,0,738,258],"PolyGraph")
     {
     Options = 2
     Curve(39976104,"Br3a",0,,,1)
     Curve(39978880,"Br3b",1,,,1)
     Curve(39981656,"Br3c",2,,,1)
     }
    }
   }
  }
 Module("Plots_B2")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Line(-13,-1,-13,-21)
   Line(-13,-4,-4,-13)
   Line(-4,-13,1,-10)
   Line(6,-16,12,-13)
   Pen(Gray)
   Line(27,28,27,-43)
   Pen(Black)
   Line(1,-10,6,-16)
   Line(-18,-4,21,-4)
   Text(1,-28,"Plots")
   Text(3,24,"B2 B4")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Plot-([18,18],0)
    {
    Title = "Plots at B2"
    Draw = 1
    Area = [0,0,756,1170]
    Posn = [18,18]
    Icon = [-1,-1]
    Extents = 0,0,756,1170
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,756,282],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(39818032,"V2a",0,,,)
     Curve(39821240,"V2b",1,,,)
     Curve(39848720,"V2c",2,,,)
     }
    Graph([0,282],[0,0,756,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(39809104,"I2a",0,,,)
     Curve(39812200,"I2b",1,,,)
     Curve(39902864,"I2c",2,,,)
     }
    Graph([0,563],[0,0,756,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(39900088,"I20",0,,,)
     }
    PGraph([0,844],[0,0,756,263],"PolyGraph")
     {
     Options = 2
     Curve(39828088,"Br2a",0,,,1)
     Curve(39840120,"Br2b",1,,,1)
     Curve(39830896,"Br2c",2,,,1)
     }
    }
   -Plot-([792,18],0)
    {
    Title = "Plots at B4"
    Draw = 1
    Area = [0,0,756,1170]
    Posn = [792,18]
    Icon = [-1,-1]
    Extents = 0,0,756,1170
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,756,282],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(40150192,"V4a",0,,,)
     Curve(39961280,"V4b",1,,,)
     Curve(40005528,"V4c",2,,,)
     }
    Graph([0,282],[0,0,756,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(39964360,"I4a",0,,,)
     Curve(39967272,"I4b",1,,,)
     Curve(39970360,"I4c",2,,,)
     }
    Graph([0,563],[0,0,756,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(39973192,"I40",0,,,)
     }
    PGraph([0,844],[0,0,756,263],"PolyGraph")
     {
     Options = 2
     Curve(39761848,"Br4a",0,,,1)
     Curve(39993336,"Br4b",1,,,1)
     Curve(39996112,"Br4c",2,,,1)
     }
    }
   }
  }
 Module("Main")
  {
  Desc = "Main Page"
  FileDate = 1144683240
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-18,-18,18,18)
   }


  Page(B/A3,Landscape,16,[597,467],100)
   {
   0.pgb([1746,1242],0,39761848,1120)
    {
    Name = "Br4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.datalabel([2124,198],2,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([2160,198],2,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([2196,198],2,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([2124,378],2,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([2160,378],2,0,-1)
    {
    Name = "I2B"
    }
   0.datalabel([2196,378],2,0,-1)
    {
    Name = "I2C"
    }
   -Wire-([1332,1206],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datatap([1350,1242],0,0,330)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1350,1278],0,0,420)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([2016,198],2,0,-1)
    {
    Name = "V1A"
    }
   0.datalabel([2052,198],2,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([2088,198],2,0,-1)
    {
    Name = "V1C"
    }
   0.datalabel([2016,378],6,0,-1)
    {
    Name = "V2A"
    }
   0.datalabel([2052,378],6,0,-1)
    {
    Name = "V2B"
    }
   0.datalabel([2088,378],6,0,-1)
    {
    Name = "V2C"
    }
   -Wire-([1944,306],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1710,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1710,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1710,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1710,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1494,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1494,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1494,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1368,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1368,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1368,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1584,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1584,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1584,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1584,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1584,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datatap([1476,1314],0,0,500)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1476,1278],0,0,450)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1476,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1476,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1476,1314],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1350,1314],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1350,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1350,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datatap([1350,1314],0,0,480)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1476,1242],0,0,370)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1458,1206],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.var([1908,900],0,39791192,230)
    {
    Name = "Stop"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.5"
    Units = "s"
    Collect = "1"
    }
   -Wire-([1494,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1368,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([954,738],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([324,630],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datalabel([342,738],0,0,-1)
    {
    Name = "FT1"
    }
   0.pgb([1872,1314],0,39796888,530)
    {
    Name = "V3rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.datalabel([558,540],0,0,-1)
    {
    Name = "FT2"
    }
   -Wire-([540,738],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.breaker3([432,522],4,0,690)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B1"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I1A"
    IBRB = "I1B"
    IBRC = "I1C"
    IBR0 = "I10"
    SBRA = "Br1A"
    SBRB = "Br1B"
    SBRC = "Br1C"
    BP = "P1"
    BQ = "Q1"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "189.3"
    Q = "-46.58"
    }
   -Wire-([1944,900],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1944,486],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1944,720],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([882,1368],0,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([882,1404],0,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([882,1440],0,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([1008,1368],0,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([1008,1404],0,0,-1)
    {
    Name = "I2B"
    }
   0.pgb([1044,1368],0,39809104,1000)
    {
    Name = "I2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-40.0"
    Max = "40.0"
    }
   0.pgb([1044,1404],0,39812200,920)
    {
    Name = "I2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-40.0"
    Max = "40.0"
    }
   0.pgb([918,1314],0,39815120,400)
    {
    Name = "V1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([1044,1242],0,39818032,300)
    {
    Name = "V2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1044,1278],0,39821240,360)
    {
    Name = "V2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.datalabel([1116,1242],0,0,-1)
    {
    Name = "Br1A"
    }
   0.datalabel([1116,1278],0,0,-1)
    {
    Name = "Br1B"
    }
   0.datalabel([1116,1314],0,0,-1)
    {
    Name = "Br1C"
    }
   0.datalabel([1224,1242],0,0,-1)
    {
    Name = "Br2A"
    }
   0.datalabel([1224,1278],0,0,-1)
    {
    Name = "Br2B"
    }
   0.pgb([1260,1242],0,39828088,1160)
    {
    Name = "Br2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([1260,1314],0,39830896,1090)
    {
    Name = "Br2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datalabel([1116,1368],0,0,-1)
    {
    Name = "P1"
    }
   0.pgb([918,1278],0,39834568,320)
    {
    Name = "V1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([1152,1278],0,39837344,1150)
    {
    Name = "Br1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([1260,1278],0,39840120,1140)
    {
    Name = "Br2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datatap([864,1242],0,0,250)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([864,1278],0,0,310)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([846,1206],2,0,-1)
    {
    Name = "V1"
    }
   0.datalabel([882,1242],2,0,-1)
    {
    Name = "V1A"
    }
   0.datalabel([882,1278],2,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([1008,1278],2,0,-1)
    {
    Name = "V2B"
    }
   0.pgb([1044,1314],0,39848720,440)
    {
    Name = "V2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   -Wire-([1116,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1116,1440],0,0,-1)
    {
    Name = "S1W"
    }
   -Wire-([1116,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1116,1476],0,0,-1)
    {
    Name = "S1Q"
    }
   -Wire-([1224,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1224,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1224,1476],0,0,-1)
    {
    Name = "S2Q"
    }
   0.datalabel([1008,1242],2,0,-1)
    {
    Name = "V2A"
    }
   0.pgb([1260,1368],0,39856512,940)
    {
    Name = "P2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   0.datalabel([1224,1440],0,0,-1)
    {
    Name = "S2W"
    }
   -Wire-([1224,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1224,1404],0,0,-1)
    {
    Name = "Q2"
    }
   -Wire-([1224,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1224,1368],0,0,-1)
    {
    Name = "P2"
    }
   -Wire-([1224,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1224,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1224,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1224,1314],0,0,-1)
    {
    Name = "Br2C"
    }
   0.datalabel([1008,1440],0,0,-1)
    {
    Name = "I2C"
    }
   -Wire-([1008,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1008,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1008,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([882,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([882,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([882,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1116,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1116,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1116,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1116,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1116,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1008,1314],2,0,-1)
    {
    Name = "V2C"
    }
   0.datatap([990,1314],0,0,410)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([990,1278],0,0,340)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([990,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([990,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([990,1314],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([882,1314],2,0,-1)
    {
    Name = "V1C"
    }
   -Wire-([864,1314],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([864,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([864,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datatap([864,1314],0,0,390)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1116,1404],0,0,-1)
    {
    Name = "Q1"
    }
   0.pgb([1152,1314],0,39878456,1110)
    {
    Name = "Br1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datatap([990,1242],0,0,280)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([972,1206],2,0,-1)
    {
    Name = "V2"
    }
   -Wire-([972,1206],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.pgb([1260,1404],0,39884024,870)
    {
    Name = "Q2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([1152,1404],0,39886872,900)
    {
    Name = "Q1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([918,1368],0,39889784,1040)
    {
    Name = "I1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-40.0"
    Max = "40.0"
    }
   0.pgb([918,1440],0,39892584,860)
    {
    Name = "I1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-40.0"
    Max = "40.0"
    }
   -Wire-([1008,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([882,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([918,1476],0,39896336,780)
    {
    Name = "I10"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.5"
    Max = "4.5"
    }
   0.datalabel([1008,1476],0,0,-1)
    {
    Name = "I20"
    }
   0.pgb([1044,1476],0,39900088,750)
    {
    Name = "I20"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-4.5"
    Max = "0.5"
    }
   0.pgb([1044,1440],0,39902864,840)
    {
    Name = "I2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-40.0"
    Max = "40.0"
    }
   0.pgb([918,1404],0,39905776,930)
    {
    Name = "I1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-40.0"
    Max = "40.0"
    }
   -Wire-([846,1206],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datalabel([882,1476],0,0,-1)
    {
    Name = "I10"
    }
   0.datalabel([1332,1206],2,0,-1)
    {
    Name = "V3"
    }
   0.datalabel([1368,1242],2,0,-1)
    {
    Name = "V3A"
    }
   0.datalabel([1368,1278],2,0,-1)
    {
    Name = "V3B"
    }
   0.datalabel([1368,1314],2,0,-1)
    {
    Name = "V3C"
    }
   0.datalabel([1494,1242],2,0,-1)
    {
    Name = "V4A"
    }
   0.datalabel([1494,1278],2,0,-1)
    {
    Name = "V4B"
    }
   0.datalabel([1494,1314],2,0,-1)
    {
    Name = "V4C"
    }
   0.datalabel([1998,612],2,0,-1)
    {
    Name = "V3A"
    }
   0.datalabel([2034,612],2,0,-1)
    {
    Name = "V3B"
    }
   0.datalabel([2070,612],2,0,-1)
    {
    Name = "V3C"
    }
   0.datalabel([1998,792],6,0,-1)
    {
    Name = "V4A"
    }
   0.datalabel([2034,792],6,0,-1)
    {
    Name = "V4B"
    }
   0.datalabel([2070,792],6,0,-1)
    {
    Name = "V4C"
    }
   0.datalabel([1368,1368],0,0,-1)
    {
    Name = "I3A"
    }
   0.datalabel([1368,1404],0,0,-1)
    {
    Name = "I3B"
    }
   0.datalabel([1368,1440],0,0,-1)
    {
    Name = "I3C"
    }
   0.datalabel([1368,1476],0,0,-1)
    {
    Name = "I30"
    }
   0.datalabel([1494,1368],0,0,-1)
    {
    Name = "I4A"
    }
   0.datalabel([1494,1404],0,0,-1)
    {
    Name = "I4B"
    }
   0.datalabel([1494,1440],0,0,-1)
    {
    Name = "I4C"
    }
   0.datalabel([1494,1476],0,0,-1)
    {
    Name = "I40"
    }
   0.datalabel([2106,612],2,0,-1)
    {
    Name = "I3A"
    }
   0.datalabel([2142,612],2,0,-1)
    {
    Name = "I3B"
    }
   0.datalabel([2178,612],2,0,-1)
    {
    Name = "I3C"
    }
   0.datalabel([2106,792],2,0,-1)
    {
    Name = "I4A"
    }
   0.datalabel([2142,792],2,0,-1)
    {
    Name = "I4B"
    }
   0.datalabel([2178,792],2,0,-1)
    {
    Name = "I4C"
    }
   0.datalabel([2196,342],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([2196,522],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([1584,1368],0,0,-1)
    {
    Name = "P3"
    }
   0.datalabel([1584,1404],0,0,-1)
    {
    Name = "Q3"
    }
   0.datalabel([1584,1242],0,0,-1)
    {
    Name = "Br3A"
    }
   0.datalabel([1584,1278],0,0,-1)
    {
    Name = "Br3B"
    }
   0.datalabel([1584,1314],0,0,-1)
    {
    Name = "Br3C"
    }
   -Wire-([1710,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1710,1242],0,0,-1)
    {
    Name = "Br4A"
    }
   0.datalabel([1710,1278],0,0,-1)
    {
    Name = "Br4B"
    }
   0.datalabel([1710,1314],0,0,-1)
    {
    Name = "Br4C"
    }
   0.datalabel([1710,1368],0,0,-1)
    {
    Name = "P4"
    }
   0.datalabel([1710,1404],0,0,-1)
    {
    Name = "Q4"
    }
   0.pgb([1404,1242],0,39940944,350)
    {
    Name = "V3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([1404,1278],0,39943776,430)
    {
    Name = "V3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([1404,1314],0,39946688,490)
    {
    Name = "V3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([1404,1368],0,39949600,910)
    {
    Name = "I3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-30.0"
    Max = "30.0"
    }
   0.pgb([1404,1404],0,39952512,830)
    {
    Name = "I3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-30.0"
    Max = "30.0"
    }
   0.pgb([1404,1440],0,39955424,760)
    {
    Name = "I3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-30.0"
    Max = "30.0"
    }
   0.pgb([1404,1476],0,39958368,710)
    {
    Name = "I30"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-4.5"
    Max = "0.5"
    }
   0.pgb([1530,1278],0,39961280,470)
    {
    Name = "V4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([1530,1368],0,39964360,890)
    {
    Name = "I4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-30.0"
    Max = "30.0"
    }
   0.pgb([1530,1404],0,39967272,810)
    {
    Name = "I4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-30.0"
    Max = "30.0"
    }
   0.pgb([1530,1440],0,39970360,730)
    {
    Name = "I4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-30.0"
    Max = "30.0"
    }
   0.pgb([1530,1476],0,39973192,700)
    {
    Name = "I40"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.5"
    Max = "4.5"
    }
   0.pgb([1620,1242],0,39976104,1130)
    {
    Name = "Br3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([1620,1278],0,39978880,1100)
    {
    Name = "Br3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([1620,1314],0,39981656,970)
    {
    Name = "Br3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([1620,1368],0,39984432,880)
    {
    Name = "P3"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   0.pgb([1620,1404],0,39987344,790)
    {
    Name = "Q3"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([1746,1368],0,39990256,850)
    {
    Name = "P4"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   0.pgb([1746,1278],0,39993336,1070)
    {
    Name = "Br4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([1746,1314],0,39996112,950)
    {
    Name = "Br4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([918,1242],0,39998864,270)
    {
    Name = "V1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([1872,1242],0,40001776,460)
    {
    Name = "V1rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   -Wire-([396,630],0,0,-1)
    {
    Vertex="0,0;-144,0"
    }
   -Wire-([1152,630],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.pgb([1530,1314],0,40005528,520)
    {
    Name = "V4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([1152,1368],0,40008440,960)
    {
    Name = "P1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   0.recorder2_0([2070,684],0,0,1280)
    {
    FName = "stn3"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "3"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V1a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V1b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V1c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I1a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I1b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I1c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.recorder2_0([2088,450],0,0,1340)
    {
    FName = "stn2"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "2"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V2a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V2b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V2c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I2a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I2b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I2c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   -Wire-([1944,306],0,0,-1)
    {
    Vertex="0,0;0,594"
    }
   0.pgb([1872,1278],0,40033952,510)
    {
    Name = "V2rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.pgb([1872,1350],0,40037048,550)
    {
    Name = "V4rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.datalabel([1134,738],0,0,-1)
    {
    Name = "FT5"
    }
   0.datalabel([738,594],0,0,-1)
    {
    Name = "FT3"
    }
   0.datalabel([738,810],0,0,-1)
    {
    Name = "FT7"
    }
   0.datalabel([234,1098],2,0,-1)
    {
    Name = "B2"
    }
   0.datalabel([270,1098],2,0,-1)
    {
    Name = "B3"
    }
   0.datalabel([198,1098],2,0,-1)
    {
    Name = "B1"
    }
   0.datatap([198,1098],6,0,650)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([306,1098],2,0,-1)
    {
    Name = "B4"
    }
   0.datatap([306,1098],6,0,620)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   -Wire-([288,1116],0,0,-1)
    {
    Vertex="0,0;-126,0"
    }
   0.datalabel([1512,918],4,0,-1)
    {
    Name = "Breakers"
    }
   0.datalabel([162,1116],0,0,-1)
    {
    Name = "Breakers"
    }
   0.datalabel([558,774],0,0,-1)
    {
    Name = "FT6"
    }
   0.datalabel([936,774],0,0,-1)
    {
    Name = "FT8"
    }
   0.datalabel([1512,954],4,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([558,558],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([342,756],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([936,558],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([738,828],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([558,792],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([936,792],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([1134,756],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([1458,1206],2,0,-1)
    {
    Name = "V4"
    }
   0.datalabel([2178,756],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([2178,936],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([738,612],0,0,-1)
    {
    Name = "Fault"
    }
   0.var([234,702],3,40060296,120)
    {
    Name = "Ph Angle"
    Group = "SS1"
    Display = "0"
    Max = "180"
    Min = "0.0"
    Value = "52.2"
    Units = "deg"
    Collect = "1"
    }
   0.var([180,702],3,40063240,110)
    {
    Name = "Voltage"
    Group = "SS1"
    Display = "0"
    Max = "500"
    Min = "0.0"
    Value = "230.0"
    Units = "kV"
    Collect = "1"
    }
   0.var([1224,702],5,40066096,150)
    {
    Name = "Ph Angle"
    Group = "SS2"
    Display = "0"
    Max = "180"
    Min = "-180"
    Value = "20.0"
    Units = "deg"
    Collect = "1"
    }
   0.var([1278,702],5,40068960,170)
    {
    Name = "Voltage"
    Group = "SS2"
    Display = "0"
    Max = "500"
    Min = "0.0"
    Value = "230.0"
    Units = "kV"
    Collect = "1"
    }
   -Wire-([198,1512],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([270,1512],0,0,-1)
    {
    Name = "Ron"
    }
   0.tpflt([306,720],0,0,1330)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([522,756],0,0,1320)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.datalabel([936,540],0,0,-1)
    {
    Name = "FT4"
    }
   0.tpflt([972,522],4,0,1360)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([972,756],4,0,1300)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([1170,720],4,0,1310)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.annotation([162,1494],0,0,-1)
    {
    AL1 = "Rf"
    AL2 = ""
    }
   0.datalabel([108,1188],2,0,-1)
    {
    Name = "FT1"
    }
   0.datalabel([144,1188],2,0,-1)
    {
    Name = "FT2"
    }
   0.datalabel([180,1188],2,0,-1)
    {
    Name = "FT3"
    }
   -Wire-([162,1278],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   0.datalabel([108,1440],0,0,-1)
    {
    Name = "F1"
    }
   0.datalabel([144,1440],0,0,-1)
    {
    Name = "F2"
    }
   0.datalabel([180,1440],0,0,-1)
    {
    Name = "F3"
    }
   0.datalabel([252,1188],2,0,-1)
    {
    Name = "FT5"
    }
   0.datalabel([288,1440],0,0,-1)
    {
    Name = "F6"
    }
   0.var_pot([90,1314],0,40090416,240)
    {
    Name = "Fault location"
    Group = ""
    Display = "0"
    NDP = "8"
    Value = "5"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "10.0"
    }
   0.unity([162,1314],0,0,260)
    {
    IType = "2"
    OType = "1"
    }
   0.datatap([108,1188],6,0,1260)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([144,1188],6,0,1250)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([180,1188],6,0,1240)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([288,1188],6,0,1210)
    {
    Index = "6"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([216,1188],2,0,-1)
    {
    Name = "FT4"
    }
   0.datatap([108,1440],0,0,1080)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([144,1440],0,0,1060)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([180,1440],0,0,1050)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([216,1440],0,0,1030)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([252,1440],0,0,1020)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([288,1188],2,0,-1)
    {
    Name = "FT6"
    }
   0.datalabel([252,1440],0,0,-1)
    {
    Name = "F5"
    }
   0.datalabel([216,1440],0,0,-1)
    {
    Name = "F4"
    }
   0.unity([198,1314],4,0,590)
    {
    IType = "2"
    OType = "1"
    }
   0.datalabel([198,1314],1,0,-1)
    {
    Name = "Faulttype"
    }
   -Wire-([198,1278],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.datalabel([198,1350],2,0,-1)
    {
    Name = "Fault"
    }
   0.datatap([270,1098],6,0,630)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([216,1188],6,0,1230)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([324,1188],6,0,1200)
    {
    Index = "7"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([324,1188],2,0,-1)
    {
    Name = "FT7"
    }
   0.datalabel([360,1188],2,0,-1)
    {
    Name = "FT8"
    }
   -Wire-([342,1206],0,0,-1)
    {
    Vertex="0,0;-252,0"
    }
   0.datatap([360,1188],6,0,1190)
    {
    Index = "8"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   -Wire-([342,1422],0,0,-1)
    {
    Vertex="0,0;-252,0"
    }
   0.datatap([288,1440],0,0,1010)
    {
    Index = "6"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([324,1440],0,0,990)
    {
    Index = "7"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([360,1440],0,0,980)
    {
    Index = "8"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([360,1440],0,0,-1)
    {
    Name = "F8"
    }
   0.datatap([234,1098],6,0,640)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([324,1440],0,0,-1)
    {
    Name = "F7"
    }
   0.mux_array([180,1386],6,0,610)
    {
    DPath = "0"
    }
   0.var_pot([270,1314],2,40123200,290)
    {
    Name = "Fault Type"
    Group = ""
    Display = "0"
    NDP = "10"
    Value = "7"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "0"
    }
   0.pgb([1152,1440],0,40126144,820)
    {
    Name = "PS1"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([1152,1476],0,40129168,740)
    {
    Name = "QS1"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([1260,1440],0,40132080,800)
    {
    Name = "PS2"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   -Bus-([1098,486],0,35731600,-1)
    {
    P1 = [0,0]
    P2 = [0,342]
    I = 1
    BASKV = 0
    IDE = 0
    GL = 0
    BL = 0
    AREA = 1
    ZONE = 0
    VM = 0
    VA = 0
    OWNER = 1
    }
   0.breaker3([1062,522],0,0,680)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B2"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I2A"
    IBRB = "I2B"
    IBRC = "I2C"
    IBR0 = "I20"
    SBRA = "Br2A"
    SBRB = "Br2B"
    SBRC = "Br2C"
    BP = "P2"
    BQ = "Q2"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "157.1"
    Q = "-35.03"
    }
   -Bus-([396,486],0,33103008,-1)
    {
    P1 = [0,0]
    P2 = [0,306]
    I = 1
    BASKV = 0
    IDE = 0
    GL = 0
    BL = 0
    AREA = 1
    ZONE = 0
    VM = 0
    VA = 0
    OWNER = 1
    }
   0.source3R([216,630],6,0,570)
    {
    Name = "Source1"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(f)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "5.29 [ohm]"
    Phi1 = "80.0 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "52.9 [ohm]"
    Phi0 = "80.0 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S1W"
    Q = "S1Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   0.source3R([1242,630],2,0,580)
    {
    Name = "Source2"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(f)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "5.29 [ohm]"
    Phi1 = "80.0 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "52.9 [ohm]"
    Phi0 = "80.0 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S2W"
    Q = "S2Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   .Plots_B2([1062,414],0,0,50)
    {
    }
   .Plots_B1([432,414],0,0,30)
    {
    }
   0.const([1782,234],1,0,20)
    {
    Name = ""
    Value = "10.0"
    }
   0.pgb([1746,1404],0,40147096,770)
    {
    Name = "Q4"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([1530,1242],0,40150192,380)
    {
    Name = "V4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([1152,1242],0,40153104,1170)
    {
    Name = "Br1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   -Sticky-([846,1116],0)
    {
    Name = ""
    Font = 1
    Bounds = 846,1116,954,1152
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "OUTPUT CHANNELS"
    }
   0.pgb([1260,1476],0,40156312,720)
    {
    Name = "QS2"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.mux_array([180,1242],0,0,1180)
    {
    DPath = "0"
    }
   0.datatap([252,1188],6,0,1220)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.var([162,1512],0,40161296,540)
    {
    Name = "Rf"
    Group = ""
    Display = "0"
    Max = "50"
    Min = "0.001"
    Value = "0.001"
    Units = "ohm"
    Collect = "1"
    }
   0.recorder2_0([2070,864],0,0,1270)
    {
    FName = "stn4"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "4"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V2a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V2b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V2c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I2a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I2b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I2c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.recorder2_0([2088,270],0,0,1380)
    {
    FName = "stn1"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "1"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V1a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V1b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V1c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I1a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I1b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I1c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.select([1818,270],6,0,560)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.const([1782,414],1,0,80)
    {
    Name = ""
    Value = "10.0"
    }
   0.select([1818,450],6,0,100)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.const([1800,648],1,0,160)
    {
    Name = ""
    Value = "10.0"
    }
   0.select([1836,684],6,0,190)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.const([1800,828],1,0,210)
    {
    Name = ""
    Value = "10.0"
    }
   0.select([1836,864],6,0,220)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.var([1710,306],0,40192208,40)
    {
    Name = "Start"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.15"
    Units = "s"
    Collect = "1"
    }
   -Wire-([1746,306],0,0,-1)
    {
    Vertex="0,0;0,594"
    }
   -Wire-([1746,486],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1746,306],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1854,450],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([1854,270],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([1872,684],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([1872,864],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([1746,900],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1746,720],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.var_switch([1818,198],1,40199104,10)
    {
    Name = "en Record1"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([1818,378],1,40201824,60)
    {
    Name = "en Record2"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([1836,612],1,40204544,140)
    {
    Name = "en Record3"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([1836,792],1,40207264,200)
    {
    Name = "en Record4"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.tpflt([522,522],0,0,1370)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   -Wire-([1098,630],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.tpflt([774,576],4,0,1350)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([774,792],4,0,1290)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.datalabel([1512,972],4,0,-1)
    {
    Name = "FaultType"
    }
   -Wire-([1566,972],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Wire-([1566,954],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Wire-([1566,918],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Sticky-([18,18],0)
    {
    Name = ""
    Font = 1
    Bounds = 18,18,540,252
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
Case 4: 
- Two Thevinen Impedance sources connected via two 100km transmission lines.
- Faults can be applied Midline on Line 1 or Line 2
- User  must  ensure the sum of lines T1+ T2, and T3 + T4, equal the total
   length of the lines they wish to simulate.
- System voltage is 230kV settable via source equivalents.
- Simulates two substations connected via two transmission lines.
- Eight fault positions for full fault control ahead and behind station relays.
- Four breakers are independently timed controlled. (Default is closed).
- Independent breaker pole tripping is possible."
    }
   -Wire-([990,522],0,0,-1)
    {
    Vertex="0,0;-126,0"
    }
   -Wire-([990,738],0,0,-1)
    {
    Vertex="0,0;-126,0"
    }
   -Wire-([504,522],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   -Wire-([504,738],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   -Sticky-([1188,522],0)
    {
    Name = ""
    Font = 1
    Bounds = 1188,522,1278,558
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 2"
    }
   -Sticky-([162,522],0)
    {
    Name = ""
    Font = 1
    Bounds = 162,522,252,558
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 1"
    }
   0.breaker3([432,738],4,0,670)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B3"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I3A"
    IBRB = "I3B"
    IBRC = "I3C"
    IBR0 = "I30"
    SBRA = "Br3A"
    SBRB = "Br3B"
    SBRC = "Br3C"
    BP = "P3"
    BQ = "Q3"
    BOpen1 = "2"
    BOpen2 = "2"
    BOpen3 = "2"
    P = "0.03243"
    Q = "-0.003508"
    }
   0.breaker3([1062,738],0,0,660)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B4"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I4A"
    IBRB = "I4B"
    IBRC = "I4C"
    IBR0 = "I40"
    SBRA = "Br4A"
    SBRB = "Br4B"
    SBRC = "Br4C"
    BP = "P4"
    BQ = "Q4"
    BOpen1 = "2"
    BOpen2 = "2"
    BOpen3 = "2"
    P = "0.001805"
    Q = "-0.00032"
    }
   .Controls([1602,954],4,0,600)
    {
    }
   0.multimeter([486,522],0,0,70)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V1"
    P = ""
    Q = ""
    Vrms = "V1rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([486,738],0,0,130)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V3"
    P = ""
    Q = ""
    Vrms = "V3rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([1008,738],4,0,180)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V4"
    P = ""
    Q = ""
    Vrms = "V4rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([1008,522],4,0,90)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V2"
    P = ""
    Q = ""
    Vrms = "V2rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   -Sticky-([738,36],0)
    {
    Name = ""
    Font = 1
    Bounds = 738,36,1134,144
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
This case uses global substitutions.  To change between 50Hz/60Hz. select Global Substitutions (Ctrl-G).  In the pop-up window, change the value of f to the desired frequency.
"
    }
   -Wire-([1836,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1836,1242],0,0,-1)
    {
    Name = "V1rms"
    }
   -Wire-([1836,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1836,1278],0,0,-1)
    {
    Name = "V2rms"
    }
   -Wire-([1836,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1836,1314],0,0,-1)
    {
    Name = "V3rms"
    }
   -Wire-([1836,1350],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1836,1350],0,0,-1)
    {
    Name = "V4rms"
    }
   -Divider-([18,1026],0)
    {
    Size(2322,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([1656,54],0)
    {
    Size(0,972)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([594,1026],0)
    {
    Size(0,504)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   0.pi_section2([756,522],0,0,-1)
    {
    Name = "Line1"
    PU = "1"
    F = "$(f)"
    len = "100.0 [km]"
    Estim = "0"
    View = "1"
    ConNeed = "1"
    Percent = "50 [%]"
    REst = "1.5"
    ZEst = "1.5"
    TEst = "1.5"
    Rp = "3.57448095e-5 [ohm/m]"
    Xp = "5.07762676e-4 [ohm/m]"
    Bp = "3.27117946e-9 [mho/m]"
    Rz = "3.63152201e-4 [ohm/m]"
    Xz = "1.32647323e-3 [ohm/m]"
    Bz = "2.32266098e-9 [mho/m]"
    VR2 = "230.0 [kV]"
    MVA2 = "100.0 [MVA]"
    RPUP2 = ".336786E-7 [pu/m]"
    XLPUP2 = ".593346E-6 [pu/m]"
    BPUP2 = "1.93387E-6 [pu/m]"
    RPUZ2 = ".558072E-6 [pu/m]"
    XLPUZ2 = ".196578E-5 [pu/m]"
    BPUZ2 = "1.27727E-6 [pu/m]"
    }
   0.pi_section2([756,738],0,0,-1)
    {
    Name = "Line2"
    PU = "1"
    F = "$(f)"
    len = "100.0 [km]"
    Estim = "0"
    View = "1"
    ConNeed = "1"
    Percent = "50 [%]"
    REst = "1.5"
    ZEst = "1.5"
    TEst = "1.5"
    Rp = "3.57448095e-5 [ohm/m]"
    Xp = "5.07762676e-4 [ohm/m]"
    Bp = "3.27117946e-9 [mho/m]"
    Rz = "3.63152201e-4 [ohm/m]"
    Xz = "1.32647323e-3 [ohm/m]"
    Bz = "2.32266098e-9 [mho/m]"
    VR2 = "230.0 [kV]"
    MVA2 = "100.0 [MVA]"
    RPUP2 = ".336786E-7 [pu/m]"
    XLPUP2 = ".593346E-6 [pu/m]"
    BPUP2 = "1.93387E-6 [pu/m]"
    RPUZ2 = ".558072E-6 [pu/m]"
    XLPUZ2 = ".196578E-5 [pu/m]"
    BPUZ2 = "1.27727E-6 [pu/m]"
    }
   }
  }
 }

